/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import org.testng.internal.junit.ArrayAsserts;

public class AssertJUnit
extends ArrayAsserts {
    protected AssertJUnit() {
    }

    public static void assertTrue(String string, boolean bl) {
        if (!bl) {
            AssertJUnit.fail(string);
        }
    }

    public static void assertTrue(boolean bl) {
        AssertJUnit.assertTrue(null, bl);
    }

    public static void assertFalse(String string, boolean bl) {
        AssertJUnit.assertTrue(string, !bl);
    }

    public static void assertFalse(boolean bl) {
        AssertJUnit.assertFalse(null, bl);
    }

    public static void fail(String string) {
        if (null == string) {
            string = "";
        }
        throw new AssertionError((Object)string);
    }

    public static void fail() {
        AssertJUnit.fail(null);
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        AssertJUnit.failNotEquals(string, object, object2);
    }

    public static void assertEquals(Object object, Object object2) {
        AssertJUnit.assertEquals(null, object, object2);
    }

    public static void assertEquals(String string, String string2, String string3) {
        if (string2 == null && string3 == null) {
            return;
        }
        if (string2 != null && string2.equals(string3)) {
            return;
        }
        throw new AssertionError((Object)AssertJUnit.format(string, string2, string3));
    }

    public static void assertEquals(String string, String string2) {
        AssertJUnit.assertEquals(null, string, string2);
    }

    public static void assertEquals(String string, double d, double d2, double d3) {
        if (Double.isInfinite(d)) {
            if (d != d2) {
                AssertJUnit.failNotEquals(string, d, d2);
            }
        } else if (!(Math.abs(d - d2) <= d3)) {
            AssertJUnit.failNotEquals(string, d, d2);
        }
    }

    public static void assertEquals(double d, double d2, double d3) {
        AssertJUnit.assertEquals(null, d, d2, d3);
    }

    public static void assertEquals(String string, float f, float f2, float f3) {
        if (Float.isInfinite(f)) {
            if (f != f2) {
                AssertJUnit.failNotEquals(string, Float.valueOf(f), Float.valueOf(f2));
            }
        } else if (!(Math.abs(f - f2) <= f3)) {
            AssertJUnit.failNotEquals(string, Float.valueOf(f), Float.valueOf(f2));
        }
    }

    public static void assertEquals(float f, float f2, float f3) {
        AssertJUnit.assertEquals(null, f, f2, f3);
    }

    public static void assertEquals(String string, long l, long l2) {
        AssertJUnit.assertEquals(string, (Object)l, (Object)l2);
    }

    public static void assertEquals(long l, long l2) {
        AssertJUnit.assertEquals(null, l, l2);
    }

    public static void assertEquals(String string, boolean bl, boolean bl2) {
        AssertJUnit.assertEquals(string, (Object)bl, (Object)bl2);
    }

    public static void assertEquals(boolean bl, boolean bl2) {
        AssertJUnit.assertEquals(null, bl, bl2);
    }

    public static void assertEquals(String string, byte by, byte by2) {
        AssertJUnit.assertEquals(string, (Object)by, (Object)by2);
    }

    public static void assertEquals(byte by, byte by2) {
        AssertJUnit.assertEquals(null, by, by2);
    }

    public static void assertEquals(String string, char c, char c2) {
        AssertJUnit.assertEquals(string, Character.valueOf(c), Character.valueOf(c2));
    }

    public static void assertEquals(char c, char c2) {
        AssertJUnit.assertEquals(null, c, c2);
    }

    public static void assertEquals(String string, short s, short s2) {
        AssertJUnit.assertEquals(string, (Object)s, (Object)s2);
    }

    public static void assertEquals(short s, short s2) {
        AssertJUnit.assertEquals(null, s, s2);
    }

    public static void assertEquals(String string, int n, int n2) {
        AssertJUnit.assertEquals(string, (Object)n, (Object)n2);
    }

    public static void assertEquals(int n, int n2) {
        AssertJUnit.assertEquals(null, n, n2);
    }

    public static void assertNotNull(Object object) {
        AssertJUnit.assertNotNull(null, object);
    }

    public static void assertNotNull(String string, Object object) {
        AssertJUnit.assertTrue(string, object != null);
    }

    public static void assertNull(Object object) {
        AssertJUnit.assertNull(null, object);
    }

    public static void assertNull(String string, Object object) {
        AssertJUnit.assertTrue(string, object == null);
    }

    public static void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        AssertJUnit.failNotSame(string, object, object2);
    }

    public static void assertSame(Object object, Object object2) {
        AssertJUnit.assertSame(null, object, object2);
    }

    public static void assertNotSame(String string, Object object, Object object2) {
        if (object == object2) {
            AssertJUnit.failSame(string);
        }
    }

    public static void assertNotSame(Object object, Object object2) {
        AssertJUnit.assertNotSame(null, object, object2);
    }

    public static void assertEquals(byte[] byArray, byte[] byArray2) {
        AssertJUnit.assertEquals("", byArray, byArray2);
    }

    public static void assertEquals(String string, byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return;
        }
        if (null == byArray) {
            AssertJUnit.fail("expected a null array, but not null found. " + string);
        }
        if (null == byArray2) {
            AssertJUnit.fail("expected not null array, but null found. " + string);
        }
        AssertJUnit.assertEquals("arrays don't have the same size. " + string, byArray.length, byArray2.length);
        for (int j = 0; j < byArray.length; ++j) {
            if (byArray[j] == byArray2[j]) continue;
            AssertJUnit.fail("arrays differ firstly at element [" + j + "]; " + AssertJUnit.format(string, byArray[j], byArray2[j]));
        }
    }

    private static void failSame(String string) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        AssertJUnit.fail(string2 + "expected not same");
    }

    private static void failNotSame(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        AssertJUnit.fail(string2 + "expected same:<" + object + "> was not:<" + object2 + ">");
    }

    private static void failNotEquals(String string, Object object, Object object2) {
        AssertJUnit.fail(AssertJUnit.format(string, object, object2));
    }

    static String format(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        return string2 + "expected:<" + object + "> but was:<" + object2 + ">";
    }
}

