/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.IReporter;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.PropertyUtils;
import org.testng.internal.Utils;

public class ReporterConfig {
    private String m_className;
    private final List<Property> m_properties = Lists.newArrayList();

    public void addProperty(Property property) {
        this.m_properties.add(property);
    }

    public List<Property> getProperties() {
        return this.m_properties;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_className);
        if (!this.m_properties.isEmpty()) {
            stringBuilder.append(":");
            for (int j = 0; j < this.m_properties.size(); ++j) {
                Property property = this.m_properties.get(j);
                stringBuilder.append(property.name);
                stringBuilder.append("=");
                stringBuilder.append(property.value);
                if (j >= this.m_properties.size() - 1) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder.toString();
    }

    public static ReporterConfig deserialize(String string) {
        if (Utils.isStringEmpty(string)) {
            return null;
        }
        ReporterConfig reporterConfig = new ReporterConfig();
        int n = string.indexOf(58);
        if (n == -1) {
            reporterConfig.setClassName(string);
        } else {
            String[] stringArray;
            reporterConfig.setClassName(string.substring(0, n));
            String string2 = string.substring(n + 1, string.length());
            for (String string3 : stringArray = string2.split(",")) {
                String[] stringArray2 = string3.split("=");
                if (stringArray2.length != 2) continue;
                reporterConfig.addProperty(new Property(stringArray2[0], stringArray2[1]));
            }
        }
        return reporterConfig;
    }

    public IReporter newReporterInstance() {
        Class<?> clazz = ClassHelper.forName(this.m_className);
        if (clazz == null) {
            return null;
        }
        Object obj = ClassHelper.newInstance(clazz);
        if (!(obj instanceof IReporter)) {
            throw new TestNGException(this.m_className + " is not a IReporter");
        }
        IReporter iReporter = (IReporter)obj;
        for (Property property : this.m_properties) {
            PropertyUtils.setProperty(iReporter, property.name, property.value);
        }
        return iReporter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nClass = " + this.m_className);
        for (Property property : this.m_properties) {
            stringBuilder.append("\n\t " + property.name + "=" + property.value);
        }
        return stringBuilder.toString();
    }

    public static class Property {
        private final String name;
        private final String value;

        public Property(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

