/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestSuite;
import org.testng.IInvokedMethodListener;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.TestListenerHelper;
import org.testng.internal.TestResult;
import org.testng.junit.IJUnitTestRunner;
import org.testng.junit.JUnit3TestClass;
import org.testng.junit.JUnit3TestMethod;

public class JUnitTestRunner
implements TestListener,
IJUnitTestRunner {
    public static final String SUITE_METHODNAME = "suite";
    private ITestResultNotifier m_parentRunner;
    private Map<Test, TestRunInfo> m_tests = new WeakHashMap<Test, TestRunInfo>();
    private List<ITestNGMethod> m_methods = Lists.newArrayList();
    private Collection<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();

    public JUnitTestRunner() {
    }

    public JUnitTestRunner(ITestResultNotifier iTestResultNotifier) {
        this.m_parentRunner = iTestResultNotifier;
    }

    @Override
    public List<ITestNGMethod> getTestMethods() {
        return this.m_methods;
    }

    @Override
    public void setTestResultNotifier(ITestResultNotifier iTestResultNotifier) {
        this.m_parentRunner = iTestResultNotifier;
    }

    @Override
    public void startTest(Test test) {
        this.m_tests.put(test, new TestRunInfo(Calendar.getInstance().getTimeInMillis()));
    }

    @Override
    public void addError(Test test, Throwable throwable) {
        this.recordFailure(test, throwable);
    }

    @Override
    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.recordFailure(test, (Throwable)((Object)assertionFailedError));
    }

    private void recordFailure(Test test, Throwable throwable) {
        TestRunInfo testRunInfo = this.m_tests.get(test);
        if (null != testRunInfo) {
            testRunInfo.setThrowable(throwable);
        }
    }

    @Override
    public void endTest(Test test) {
        TestRunInfo testRunInfo = this.m_tests.get(test);
        if (null == testRunInfo) {
            return;
        }
        TestResult testResult = this.recordResults(test, testRunInfo);
        TestListenerHelper.runTestListeners(testResult, this.m_parentRunner.getTestListeners());
    }

    @Override
    public void setInvokedMethodListeners(Collection<IInvokedMethodListener> collection) {
        this.m_invokedMethodListeners = collection;
    }

    private TestResult recordResults(Test test, TestRunInfo testRunInfo) {
        JUnit3TestClass jUnit3TestClass = new JUnit3TestClass(test);
        JUnit3TestMethod jUnit3TestMethod = new JUnit3TestMethod(jUnit3TestClass, test);
        TestResult testResult = new TestResult(jUnit3TestClass, test, jUnit3TestMethod, testRunInfo.m_failure, testRunInfo.m_start, Calendar.getInstance().getTimeInMillis(), null);
        if (testRunInfo.isFailure()) {
            testResult.setStatus(2);
            this.m_parentRunner.addFailedTest(jUnit3TestMethod, testResult);
        } else {
            this.m_parentRunner.addPassedTest(jUnit3TestMethod, testResult);
        }
        InvokedMethod invokedMethod = new InvokedMethod(test, jUnit3TestMethod, testRunInfo.m_start, testResult);
        this.m_parentRunner.addInvokedMethod(invokedMethod);
        this.m_methods.add(jUnit3TestMethod);
        for (IInvokedMethodListener iInvokedMethodListener : this.m_invokedMethodListeners) {
            iInvokedMethodListener.beforeInvocation(invokedMethod, testResult);
        }
        return testResult;
    }

    protected Test getTest(Class clazz, String ... stringArray) {
        if (stringArray.length > 0) {
            TestSuite testSuite = new TestSuite();
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                for (String string : stringArray) {
                    try {
                        testSuite.addTest((Test)constructor.newInstance(string));
                    }
                    catch (InstantiationException instantiationException) {
                        this.runFailed(clazz, "abstract class " + instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.runFailed(clazz, "constructor is not public " + illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.runFailed(clazz, "actual and formal parameters differ " + illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.runFailed(clazz, "exception while instatiating test for method '" + string + "' " + invocationTargetException);
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.runFailed(clazz, "no constructor accepting String argument found " + noSuchMethodException);
            }
            catch (SecurityException securityException) {
                this.runFailed(clazz, "security exception " + securityException);
            }
            return testSuite;
        }
        Method method = null;
        try {
            method = clazz.getMethod(SUITE_METHODNAME, new Class[0]);
        }
        catch (Exception exception) {
            return new TestSuite((Class<?>)clazz);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            this.runFailed(clazz, "suite() method must be static");
            return null;
        }
        Test test = null;
        try {
            test = (Test)method.invoke(null, (Object[])new Class[0]);
            if (test == null) {
                return test;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.runFailed(clazz, "failed to invoke method suite():" + invocationTargetException.getTargetException().toString());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.runFailed(clazz, "failed to invoke method suite():" + illegalAccessException.toString());
            return null;
        }
        return test;
    }

    @Override
    public void run(Class clazz, String ... stringArray) {
        this.start(clazz, stringArray);
    }

    public junit.framework.TestResult start(Class clazz, String ... stringArray) {
        try {
            Test test = this.getTest(clazz, stringArray);
            if (null != test) {
                return this.doRun(test);
            }
            this.runFailed(clazz, "could not create/run JUnit test suite");
        }
        catch (Exception exception) {
            this.runFailed(clazz, "could not create/run JUnit test suite: " + exception.getMessage());
        }
        return null;
    }

    protected void runFailed(Class clazz, String string) {
        throw new TestNGException("Failure in JUnit mode for class " + clazz.getName() + ": " + string);
    }

    protected junit.framework.TestResult createTestResult() {
        return new junit.framework.TestResult();
    }

    protected junit.framework.TestResult doRun(Test test) {
        junit.framework.TestResult testResult = this.createTestResult();
        testResult.addListener(this);
        test.run(testResult);
        return testResult;
    }

    private static class TestRunInfo {
        private final long m_start;
        private Throwable m_failure;

        public TestRunInfo(long l) {
            this.m_start = l;
        }

        public boolean isFailure() {
            return null != this.m_failure;
        }

        public void setThrowable(Throwable throwable) {
            this.m_failure = throwable;
        }
    }
}

