/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlSuite;

public class EmailableReporter
implements IReporter {
    private static final Logger L = Logger.getLogger(EmailableReporter.class);
    private PrintWriter m_out;
    private int m_row;
    private Integer m_testIndex;
    private int m_methodIndex;
    private String fileName = "emailable-report.html";
    private static final String JVM_ARG = "emailable.report.name";

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        try {
            this.m_out = this.createWriter(string);
        }
        catch (IOException iOException) {
            L.error("output file", iOException);
            return;
        }
        this.startHtml(this.m_out);
        this.generateSuiteSummaryReport(list2);
        this.generateMethodSummaryReport(list2);
        this.generateMethodDetailReport(list2);
        this.endHtml(this.m_out);
        this.m_out.flush();
        this.m_out.close();
    }

    protected PrintWriter createWriter(String string) throws IOException {
        new File(string).mkdirs();
        String string2 = System.getProperty(JVM_ARG);
        if (string2 != null && !string2.trim().isEmpty()) {
            this.fileName = string2;
        }
        return new PrintWriter(Files.newBufferedWriter(new File(string, this.fileName).toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
    }

    protected void generateMethodSummaryReport(List<ISuite> list) {
        this.m_methodIndex = 0;
        this.startResultSummaryTable();
        int n = 1;
        for (ISuite iSuite : list) {
            if (list.size() > 1) {
                this.titleRow(iSuite.getName(), 5);
            }
            Map<String, ISuiteResult> map = iSuite.getResults();
            for (ISuiteResult iSuiteResult : map.values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                String string = iTestContext.getName();
                this.m_testIndex = n;
                this.resultSummary(iSuite, iTestContext.getFailedConfigurations(), string, "failed", " (configuration methods)");
                this.resultSummary(iSuite, iTestContext.getFailedTests(), string, "failed", "");
                this.resultSummary(iSuite, iTestContext.getSkippedConfigurations(), string, "skipped", " (configuration methods)");
                this.resultSummary(iSuite, iTestContext.getSkippedTests(), string, "skipped", "");
                this.resultSummary(iSuite, iTestContext.getPassedTests(), string, "passed", "");
                ++n;
            }
        }
        this.m_out.println("</table>");
    }

    protected void generateMethodDetailReport(List<ISuite> list) {
        this.m_methodIndex = 0;
        for (ISuite iSuite : list) {
            Map<String, ISuiteResult> map = iSuite.getResults();
            for (ISuiteResult iSuiteResult : map.values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                if (map.values().size() > 0) {
                    this.m_out.println("<h1>" + iTestContext.getName() + "</h1>");
                }
                this.resultDetail(iTestContext.getFailedConfigurations());
                this.resultDetail(iTestContext.getFailedTests());
                this.resultDetail(iTestContext.getSkippedConfigurations());
                this.resultDetail(iTestContext.getSkippedTests());
                this.resultDetail(iTestContext.getPassedTests());
            }
        }
    }

    private void resultSummary(ISuite iSuite, IResultMap iResultMap, String string, String string2, String string3) {
        if (!iResultMap.getAllResults().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = "";
            int n = 0;
            int n2 = 0;
            for (ITestNGMethod iTestNGMethod : this.getMethodSet(iResultMap, iSuite)) {
                Set<ITestResult> set;
                ++this.m_row;
                ++this.m_methodIndex;
                ITestClass iTestClass = iTestNGMethod.getTestClass();
                String string5 = iTestClass.getName();
                if (n == 0) {
                    set = this.m_testIndex == null ? null : "t" + Integer.toString(this.m_testIndex);
                    this.titleRow(string + " &#8212; " + string2 + string3, 5, (String)((Object)set));
                    this.m_testIndex = null;
                }
                if (!string5.equalsIgnoreCase(string4)) {
                    if (n > 0) {
                        this.m_out.print("<tr class=\"" + string2 + (++n2 % 2 == 0 ? "even" : "odd") + "\"><td");
                        if (n > 1) {
                            this.m_out.print(" rowspan=\"" + n + "\"");
                        }
                        this.m_out.println(">" + string4 + "</td>" + stringBuilder);
                    }
                    n = 0;
                    stringBuilder.setLength(0);
                    string4 = string5;
                }
                set = iResultMap.getResults(iTestNGMethod);
                long l = Long.MIN_VALUE;
                long l2 = Long.MAX_VALUE;
                for (ITestResult iTestResult : iResultMap.getResults(iTestNGMethod)) {
                    if (iTestResult.getEndMillis() > l) {
                        l = iTestResult.getEndMillis();
                    }
                    if (iTestResult.getStartMillis() >= l2) continue;
                    l2 = iTestResult.getStartMillis();
                }
                if (++n > 1) {
                    stringBuilder.append("<tr class=\"").append(string2).append(n2 % 2 == 0 ? "odd" : "even").append("\">");
                }
                String string6 = iTestNGMethod.getDescription();
                String object2 = set.toArray(new ITestResult[0])[0].getTestName();
                stringBuilder.append("<td><a href=\"#m").append(this.m_methodIndex).append("\">").append(this.qualifiedName(iTestNGMethod)).append(" ");
                if (string6 != null && !string6.isEmpty()) {
                    stringBuilder.append("(\"").append(string6).append("\")");
                }
                stringBuilder.append("</a>");
                if (object2 != null) {
                    stringBuilder.append("<br>(").append(object2).append(")");
                }
                stringBuilder.append("</td>").append("<td class=\"numi\">").append(set.size()).append("</td>").append("<td>").append(l2).append("</td>").append("<td class=\"numi\">").append(l - l2).append("</td>").append("</tr>");
            }
            if (n > 0) {
                this.m_out.print("<tr class=\"" + string2 + (++n2 % 2 == 0 ? "even" : "odd") + "\"><td");
                if (n > 1) {
                    this.m_out.print(" rowspan=\"" + n + "\"");
                }
                this.m_out.println(">" + string4 + "</td>" + stringBuilder);
            }
        }
    }

    private void startResultSummaryTable() {
        this.tableStart("methodOverview", "summary");
        this.m_out.println("<tr><th>Class</th><th>Method</th><th># of<br/>Scenarios</th><th>Start</th><th>Time<br/>(ms)</th></tr>");
        this.m_row = 0;
    }

    private String qualifiedName(ITestNGMethod iTestNGMethod) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = iTestNGMethod.getGroups();
        int n = stringArray.length;
        if (n > 0 && !"basic".equalsIgnoreCase(stringArray[0])) {
            stringBuilder.append("(");
            for (int j = 0; j < n; ++j) {
                if (j > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[j]);
            }
            stringBuilder.append(")");
        }
        return "<b>" + iTestNGMethod.getMethodName() + "</b> " + stringBuilder;
    }

    private void resultDetail(IResultMap iResultMap) {
        for (ITestResult iTestResult : iResultMap.getAllResults()) {
            ITestNGMethod iTestNGMethod = iTestResult.getMethod();
            ++this.m_methodIndex;
            String string = iTestNGMethod.getTestClass().getName();
            this.m_out.println("<h2 id=\"m" + this.m_methodIndex + "\">" + string + ":" + iTestNGMethod.getMethodName() + "</h2>");
            this.generateForResult(iTestResult, iTestNGMethod);
            this.m_out.println("<p class=\"totop\"><a href=\"#summary\">back to summary</a></p>");
        }
    }

    private void generateForResult(ITestResult iTestResult, ITestNGMethod iTestNGMethod) {
        boolean bl;
        Object[] objectArray;
        boolean bl2;
        Object[] objectArray2 = iTestResult.getParameters();
        boolean bl3 = bl2 = objectArray2 != null && objectArray2.length > 0;
        if (bl2) {
            this.tableStart("result", null);
            this.m_out.print("<tr class=\"param\">");
            for (int j = 1; j <= objectArray2.length; ++j) {
                this.m_out.print("<th>Parameter #" + j + "</th>");
            }
            this.m_out.println("</tr>");
            this.m_out.print("<tr class=\"param stripe\">");
            for (Object object : objectArray2) {
                this.m_out.println("<td>" + Utils.escapeHtml(Utils.toString(object)) + "</td>");
            }
            this.m_out.println("</tr>");
        }
        int n = !(objectArray = Reporter.getOutput(iTestResult)).isEmpty() ? 1 : 0;
        Throwable throwable = iTestResult.getThrowable();
        boolean bl4 = bl = throwable != null;
        if (n != 0 || bl) {
            if (bl2) {
                this.m_out.print("<tr><td");
                if (objectArray2.length > 1) {
                    this.m_out.print(" colspan=\"" + objectArray2.length + "\"");
                }
                this.m_out.println(">");
            } else {
                this.m_out.println("<div>");
            }
            if (n != 0) {
                if (bl) {
                    this.m_out.println("<h3>Test Messages</h3>");
                }
                for (String string : objectArray) {
                    this.m_out.println(string + "<br/>");
                }
            }
            if (bl) {
                boolean bl5;
                boolean bl6 = bl5 = iTestResult.getStatus() == 1;
                if (n != 0) {
                    this.m_out.println("<h3>" + (bl5 ? "Expected Exception" : "Failure") + "</h3>");
                }
                this.generateExceptionReport(throwable, iTestNGMethod);
            }
            if (bl2) {
                this.m_out.println("</td></tr>");
            } else {
                this.m_out.println("</div>");
            }
        }
        if (bl2) {
            this.m_out.println("</table>");
        }
    }

    protected void generateExceptionReport(Throwable throwable, ITestNGMethod iTestNGMethod) {
        this.m_out.print("<div class=\"stacktrace\">");
        this.m_out.print(Utils.shortStackTrace(throwable, true));
        this.m_out.println("</div>");
    }

    private Collection<ITestNGMethod> getMethodSet(IResultMap iResultMap, ISuite iSuite) {
        List<Object> list = Lists.newArrayList();
        List<IInvokedMethod> list2 = iSuite.getAllInvokedMethods();
        for (IInvokedMethod iterator : list2) {
            if (!iResultMap.getAllMethods().contains(iterator.getTestMethod())) continue;
            list.add(iterator);
        }
        Arrays.sort(list.toArray(new IInvokedMethod[list.size()]), new TestSorter());
        List list3 = Lists.newArrayList();
        for (IInvokedMethod iInvokedMethod : list) {
            list3.add(iInvokedMethod.getTestMethod());
        }
        for (ITestNGMethod iTestNGMethod : iResultMap.getAllMethods()) {
            if (list3.contains(iTestNGMethod)) continue;
            list3.add(iTestNGMethod);
        }
        return list3;
    }

    public void generateSuiteSummaryReport(List<ISuite> list) {
        this.tableStart("testOverview", null);
        this.m_out.print("<tr>");
        this.tableColumnStart("Test");
        this.tableColumnStart("Methods<br/>Passed");
        this.tableColumnStart("Scenarios<br/>Passed");
        this.tableColumnStart("# skipped");
        this.tableColumnStart("# failed");
        this.tableColumnStart("Total<br/>Time");
        this.tableColumnStart("Included<br/>Groups");
        this.tableColumnStart("Excluded<br/>Groups");
        this.m_out.println("</tr>");
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.0");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l = Long.MAX_VALUE;
        long l2 = Long.MIN_VALUE;
        this.m_testIndex = 1;
        for (ISuite iSuite : list) {
            if (list.size() > 1) {
                this.titleRow(iSuite.getName(), 8);
            }
            Map<String, ISuiteResult> map = iSuite.getResults();
            for (ISuiteResult iSuiteResult : map.values()) {
                ++n;
                ITestContext iTestContext = iSuiteResult.getTestContext();
                this.startSummaryRow(iTestContext.getName());
                int n6 = this.getMethodSet(iTestContext.getPassedTests(), iSuite).size();
                n2 += n6;
                this.summaryCell(n6, Integer.MAX_VALUE);
                n6 = iTestContext.getPassedTests().size();
                n3 += n6;
                this.summaryCell(n6, Integer.MAX_VALUE);
                n6 = this.getMethodSet(iTestContext.getSkippedTests(), iSuite).size();
                n4 += n6;
                this.summaryCell(n6, 0);
                n6 = this.getMethodSet(iTestContext.getFailedTests(), iSuite).size();
                n5 += n6;
                this.summaryCell(n6, 0);
                l = Math.min(iTestContext.getStartDate().getTime(), l);
                l2 = Math.max(iTestContext.getEndDate().getTime(), l2);
                this.summaryCell(decimalFormat.format((double)(iTestContext.getEndDate().getTime() - iTestContext.getStartDate().getTime()) / 1000.0) + " seconds", true);
                this.summaryCell(iTestContext.getIncludedGroups());
                this.summaryCell(iTestContext.getExcludedGroups());
                this.m_out.println("</tr>");
                Integer n7 = this.m_testIndex;
                Integer n8 = this.m_testIndex = Integer.valueOf(this.m_testIndex + 1);
            }
        }
        if (n > 1) {
            this.m_out.println("<tr class=\"total\"><td>Total</td>");
            this.summaryCell(n2, Integer.MAX_VALUE);
            this.summaryCell(n3, Integer.MAX_VALUE);
            this.summaryCell(n4, 0);
            this.summaryCell(n5, 0);
            this.summaryCell(decimalFormat.format((double)(l2 - l) / 1000.0) + " seconds", true);
            this.m_out.println("<td colspan=\"2\">&nbsp;</td></tr>");
        }
        this.m_out.println("</table>");
    }

    private void summaryCell(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(" ");
        }
        this.summaryCell(stringBuilder.toString(), true);
    }

    private void summaryCell(String string, boolean bl) {
        this.m_out.print("<td class=\"numi" + (bl ? "" : "_attn") + "\">" + string + "</td>");
    }

    private void startSummaryRow(String string) {
        ++this.m_row;
        this.m_out.print("<tr" + (this.m_row % 2 == 0 ? " class=\"stripe\"" : "") + "><td style=\"text-align:left;padding-right:2em\"><a href=\"#t" + this.m_testIndex + "\">" + string + "</a></td>");
    }

    private void summaryCell(int n, int n2) {
        this.summaryCell(String.valueOf(n), n <= n2);
    }

    private void tableStart(String string, String string2) {
        this.m_out.println("<table cellspacing=\"0\" cellpadding=\"0\"" + (string != null ? " class=\"" + string + "\"" : " style=\"padding-bottom:2em\"") + (string2 != null ? " id=\"" + string2 + "\"" : "") + ">");
        this.m_row = 0;
    }

    private void tableColumnStart(String string) {
        this.m_out.print("<th>" + string + "</th>");
    }

    private void titleRow(String string, int n) {
        this.titleRow(string, n, null);
    }

    private void titleRow(String string, int n, String string2) {
        this.m_out.print("<tr");
        if (string2 != null) {
            this.m_out.print(" id=\"" + string2 + "\"");
        }
        this.m_out.println("><th colspan=\"" + n + "\">" + string + "</th></tr>");
        this.m_row = 0;
    }

    protected void startHtml(PrintWriter printWriter) {
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        printWriter.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        printWriter.println("<head>");
        printWriter.println("<meta charset='utf-8'>");
        printWriter.println("<title>TestNG Report</title>");
        printWriter.println("<style type=\"text/css\">");
        printWriter.println("table {margin-bottom:10px;border-collapse:collapse;empty-cells:show}");
        printWriter.println("td,th {border:1px solid #009;padding:.25em .5em}");
        printWriter.println(".result th {vertical-align:bottom}");
        printWriter.println(".param th {padding-left:1em;padding-right:1em}");
        printWriter.println(".param td {padding-left:.5em;padding-right:2em}");
        printWriter.println(".stripe td,.stripe th {background-color: #E6EBF9}");
        printWriter.println(".numi,.numi_attn {text-align:right}");
        printWriter.println(".total td {font-weight:bold}");
        printWriter.println(".passedodd td {background-color: #0A0}");
        printWriter.println(".passedeven td {background-color: #3F3}");
        printWriter.println(".skippedodd td {background-color: #CCC}");
        printWriter.println(".skippedodd td {background-color: #DDD}");
        printWriter.println(".failedodd td,.numi_attn {background-color: #F33}");
        printWriter.println(".failedeven td,.stripe .numi_attn {background-color: #D00}");
        printWriter.println(".stacktrace {white-space:pre;font-family:monospace}");
        printWriter.println(".totop {font-size:85%;text-align:center;border-bottom:2px solid #000}");
        printWriter.println("</style>");
        printWriter.println("</head>");
        printWriter.println("<body>");
    }

    protected void endHtml(PrintWriter printWriter) {
        printWriter.println("</body></html>");
    }

    private static final class TestSorter
    implements Comparator<IInvokedMethod> {
        private TestSorter() {
        }

        @Override
        public int compare(IInvokedMethod iInvokedMethod, IInvokedMethod iInvokedMethod2) {
            return (int)(iInvokedMethod.getDate() - iInvokedMethod2.getDate());
        }
    }
}

