/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.reporters.Files;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

@Deprecated
public class JqReporter
implements IReporter {
    private static final String C = "class";
    private static final String D = "div";
    private static final String S = "span";
    private int m_testCount = 0;
    private String m_outputDirectory;
    private Map<String, String> m_testMap = Maps.newHashMap();

    public JqReporter() {
        System.err.println("JqReporter is deprecated. Use 'org.testng.reporters.jq.Main' instead.");
    }

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        this.m_outputDirectory = string;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer("  ");
        xMLStringBuffer.push(D, "id", "suites");
        this.generateSuites(list, list2, xMLStringBuffer);
        xMLStringBuffer.pop(D);
        try {
            String string2 = Files.readFile(new File(this.m_outputDirectory + "/head"));
            Utils.writeFile(this.m_outputDirectory, "index2.html", string2 + xMLStringBuffer.toXML());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private XMLStringBuffer generateSuites(List<XmlSuite> list, List<ISuite> list2, XMLStringBuffer xMLStringBuffer) {
        for (ISuite iSuite : list2) {
            if (iSuite.getResults().size() == 0) continue;
            XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
            XMLStringBuffer xMLStringBuffer3 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
            xMLStringBuffer2.push(D, C, "suite-content");
            Map<String, ISuiteResult> map = iSuite.getResults();
            XMLStringBuffer xMLStringBuffer4 = new XMLStringBuffer(xMLStringBuffer2.getCurrentIndent());
            XMLStringBuffer xMLStringBuffer5 = new XMLStringBuffer(xMLStringBuffer2.getCurrentIndent());
            XMLStringBuffer xMLStringBuffer6 = new XMLStringBuffer(xMLStringBuffer2.getCurrentIndent());
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (ISuiteResult iSuiteResult : map.values()) {
                ITestContext iTestContext = iSuiteResult.getTestContext();
                n += iTestContext.getFailedTests().size();
                this.generateTests("failed", iTestContext.getFailedTests(), iTestContext, xMLStringBuffer4);
                n2 += iTestContext.getSkippedTests().size();
                this.generateTests("skipped", iTestContext.getSkippedTests(), iTestContext, xMLStringBuffer5);
                n3 += iTestContext.getPassedTests().size();
                this.generateTests("passed", iTestContext.getPassedTests(), iTestContext, xMLStringBuffer6);
            }
            xMLStringBuffer2.addOptional(D, "Failed tests", C, "result-banner failed");
            xMLStringBuffer2.addString(xMLStringBuffer4.toXML());
            xMLStringBuffer2.addOptional(D, "Skipped tests", C, "result-banner skipped");
            xMLStringBuffer2.addString(xMLStringBuffer5.toXML());
            xMLStringBuffer2.addOptional(D, "Passed tests", C, "result-banner passed");
            xMLStringBuffer2.addString(xMLStringBuffer6.toXML());
            xMLStringBuffer3.push(D, C, "suite");
            xMLStringBuffer3.push(D, C, "suite-header");
            xMLStringBuffer3.addOptional(S, iSuite.getName(), C, "suite-name");
            xMLStringBuffer3.push(D, C, "stats");
            int n4 = n + n2 + n3;
            String object2 = String.format("%s, %d failed, %d skipped, %d passed", this.pluralize(n4, "method"), n, n2, n3);
            xMLStringBuffer3.push("ul");
            xMLStringBuffer3.push("li");
            xMLStringBuffer3.addOptional(S, object2, C, "method-stats");
            xMLStringBuffer3.pop("li");
            xMLStringBuffer3.push("li");
            xMLStringBuffer3.addOptional(S, String.format("%s ", this.pluralize(map.values().size(), "test"), C, "test-stats"));
            xMLStringBuffer3.pop("li");
            xMLStringBuffer3.push("ul");
            for (ISuiteResult iSuiteResult : map.values()) {
                String string = iSuiteResult.getTestContext().getName();
                xMLStringBuffer3.push("li");
                xMLStringBuffer3.addOptional("a", string, "href", "#" + this.m_testMap.get(string));
                xMLStringBuffer3.pop("li");
            }
            xMLStringBuffer3.pop("ul");
            xMLStringBuffer3.pop("ul");
            xMLStringBuffer3.pop(D);
            xMLStringBuffer3.pop(D);
            xMLStringBuffer.addString(xMLStringBuffer3.toXML());
            xMLStringBuffer.addString(xMLStringBuffer2.toXML());
        }
        return xMLStringBuffer;
    }

    private String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private void generateTests(String string, IResultMap iResultMap, ITestContext iTestContext, XMLStringBuffer xMLStringBuffer) {
        if (iResultMap.getAllMethods().isEmpty()) {
            return;
        }
        xMLStringBuffer.push(D, C, "test" + (string != null ? " " + string : ""));
        ListMultiMap<Class, ITestResult> listMultiMap = Maps.newListMultiMap();
        for (ITestResult object : iResultMap.getAllResults()) {
            listMultiMap.put(object.getTestClass().getRealClass(), object);
        }
        String string2 = "test-" + this.m_testCount++;
        this.m_testMap.put(iTestContext.getName(), string2);
        xMLStringBuffer.push(D, C, "test-name");
        xMLStringBuffer.push("a", "name", string2);
        xMLStringBuffer.addString(iTestContext.getName());
        xMLStringBuffer.pop("a");
        xMLStringBuffer.push("a", C, "expand", "href", "#");
        xMLStringBuffer.addEmptyElement("img", "src", JqReporter.getStatusImage(string));
        xMLStringBuffer.pop("a");
        xMLStringBuffer.pop(D);
        xMLStringBuffer.push(D, C, "test-content");
        for (Class clazz : listMultiMap.keySet()) {
            xMLStringBuffer.push(D, C, C);
            xMLStringBuffer.push(D, C, "class-header");
            xMLStringBuffer.addEmptyElement("img", "src", JqReporter.getImage(string));
            xMLStringBuffer.addOptional(S, clazz.getName(), C, "class-name");
            xMLStringBuffer.pop(D);
            xMLStringBuffer.push(D, C, "class-content");
            List list = (List)listMultiMap.get(clazz);
            for (ITestResult iTestResult : list) {
                this.generateMethod(string, iTestResult, iTestContext, xMLStringBuffer);
            }
            xMLStringBuffer.pop(D);
            xMLStringBuffer.pop(D);
        }
        xMLStringBuffer.pop(D);
        xMLStringBuffer.pop(D);
    }

    private static String getStatusImage(String string) {
        return "up.png";
    }

    private static String getImage(String string) {
        return string + ".png";
    }

    private void generateMethod(String string, ITestResult iTestResult, ITestContext iTestContext, XMLStringBuffer xMLStringBuffer) {
        StringBuilder stringBuilder;
        long l = iTestResult.getEndMillis() - iTestResult.getStartMillis();
        xMLStringBuffer.push(D, C, "method");
        xMLStringBuffer.push(D, C, "method-content");
        xMLStringBuffer.addOptional(S, iTestResult.getMethod().getMethodName(), C, "method-name");
        if (iTestResult.getParameters().length > 0) {
            stringBuilder = new StringBuilder();
            boolean bl = true;
            Object[] objectArray = iTestResult.getParameters();
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object object = objectArray[j];
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(Utils.toString(object));
            }
            xMLStringBuffer.addOptional(S, "(" + stringBuilder.toString() + ")", C, "parameters");
        }
        if (iTestResult.getThrowable() != null) {
            stringBuilder = new StringBuilder();
            for (StackTraceElement stackTraceElement : iTestResult.getThrowable().getStackTrace()) {
                stringBuilder.append(stackTraceElement.toString()).append("<br>");
            }
            xMLStringBuffer.addOptional(D, stringBuilder.toString() + "\n", C, "stack-trace");
        }
        xMLStringBuffer.addOptional(S, " " + Long.toString(l) + " ms", C, "method-time");
        xMLStringBuffer.pop(D);
        xMLStringBuffer.pop(D);
    }

    protected String generateOutputDirectoryName(String string) {
        return string;
    }

    private String pluralize(int n, String string) {
        return Integer.toString(n) + " " + (n > 1 ? (string.endsWith("s") ? string + "es" : string + "s") : string);
    }
}

