const utils = require('../utils/utils');
const challengeService = require('../services/challenge');

exports.getChallenges = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await challengeService.getChallenges(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.setCurrentChallenge = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { challengeId = '' } = req.body;
  try {
    const data = await challengeService.setCurrentChallenge(userId, challengeId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
