const utils = require('../utils/utils');
const questionnarieService = require('../services/questionnarie');

exports.getInitialData = async (req, res) => {
  const { cardinalPowerId = '' } = req.query;
  try {
    const data = await questionnarieService.getInitialData(cardinalPowerId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.create = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { suscriptionTypeId = '', cardinalPowerId = '', answers = [] } = req.body;

  if (!userId || !suscriptionTypeId || answers.length === 0) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await questionnarieService.create(
      userId,
      suscriptionTypeId,
      cardinalPowerId,
      answers,
    );

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.getReport = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const { suscriptionTypeId = '' } = req.params;

  if (!userId || !suscriptionTypeId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await questionnarieService.getReport(userId, suscriptionTypeId);
    //#NEW 
    await questionnarieService.sendEmailReportDownload(userId);
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.results = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { suscriptionTypeId = '' } = req.params;

  if (!userId || !suscriptionTypeId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await questionnarieService.results(userId, suscriptionTypeId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.update = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  const { suscriptionTypeId = '', cardinalPowerId = '', answers = [] } = req.body;

  if (!userId || !suscriptionTypeId || answers.length === 0) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await questionnarieService.update(
      userId,
      suscriptionTypeId,
      cardinalPowerId,
      answers,
    );

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
