const utils = require('../utils/utils');
const userService = require('../services/user');

exports.getRegisterInitialData = async (req, res) => {
  try {
    const data = await userService.getRegisterInitialData();

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.login = async (req, res) => {
  const { email, password } = req.body;

  if (!email || !password) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.login(email, password);
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.create = async (req, res) => {
  const {
    firstName = '',
    lastName = '',
    city = '',
    email = '',
    password = '',
    gender = null,
    phone = '',
    countryId = null,
    educationalLevelId = '',
    preferencesId = [],
    routeId = '',
    coachingReasonId = '',
    initialSuscriptionTypeId = 1,
    profileImage = '',
  } = req.body;

  if (
    !firstName
    || !lastName
    || !city
    || !email
    || !password
    || !phone
    || !educationalLevelId
    || !coachingReasonId
  ) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.create({
      firstName,
      lastName,
      city,
      email,
      password,
      gender,
      phone,
      countryId,
      educationalLevelId,
      preferencesId,
      routeId,
      coachingReasonId,
      initialSuscriptionTypeId,
      profileImage,
    });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.confirmEmail = async (req, res) => {
  const { email = '', code = '' } = req.body;

  if (!email || !code) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.confirmEmail(email, code);
    
    //#NEW
    await userService.sendConfirmationRegister( email );
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.sendConfirmationEmailCode = async (req, res) => {
  const {
    _doc = {},
  } = req.user || {};

  const { userId = null } = _doc;

  const { email = '' } = req.body;

  if (!email && !userId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.sendConfirmationEmailCode({ email, userId });
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.sendResetPasswordCode = async (req, res) => {
  const { email = '' } = req.body;

  if (!email) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.sendResetPasswordCode(email);
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.validateResetPasswordCode = async (req, res) => {
  const { email = '', code = '', password = '' } = req.body;

  if (!email || !code || !password) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.validateResetPasswordCode(email, code, password);
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.update = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    firstName = '',
    lastName = '',
    city = '',
    email = '',
    gender = null,
    phone = '',
    countryId = null,
    educationalLevelId = '',
    preferencesId = [],
    coachingReasonId = '',
    profileImage = '',
  } = req.body;

  if (
    !firstName
    || !lastName
    || !city
    || !email
    || !phone
    || !educationalLevelId
    || !coachingReasonId
  ) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.update({
      userId,
      firstName,
      lastName,
      city,
      email,
      gender,
      phone,
      countryId,
      educationalLevelId,
      preferencesId,
      coachingReasonId,
      profileImage,
    });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.updatePassword = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    currentPassword = '',
    newPassword = '',
  } = req.body;

  if (
    !currentPassword
    || !newPassword
  ) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.updatePassword({
      userId,
      currentPassword,
      newPassword,
    });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.detail = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  if (!userId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await userService.detail(userId);
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.addDeviceToken = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    deviceToken,
    deviceOS,
    deviceVersion,
  } = req.body;

  try {
    const data = await userService.addDeviceToken({
      userId,
      deviceToken,
      deviceOS,
      deviceVersion,
    });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.removeDeviceToken = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    deviceToken,
  } = req.body;

  try {
    const data = await userService.removeDeviceToken({
      userId,
      deviceToken,
    });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
