module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('preferences', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    name: {
      allowNull: false,
      type: Sequelize.STRING,
    },
    icon: {
      type: Sequelize.TEXT,
    },
    peferenceTypeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'preference_types',
        key: 'id',
      },
      field: 'preference_type_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('preferences'),
};
