module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_routes', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id',
      },
      field: 'user_id',
    },
    routeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'routes',
        key: 'id',
      },
      field: 'route_id',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
    deletedAt: {
      type: Sequelize.DATE,
      field: 'deleted_at',
    },
    enabledDate: {
      type: Sequelize.DATE,
      field: 'enabled_date',
    },
    disabledDate: {
      type: Sequelize.DATE,
      field: 'disabled_date',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_routes'),
};
