module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_notifications', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'users',
        key: 'id',
      },
      field: 'user_id',
    },
    actionPlanId: {
      allowNull: true,
      type: Sequelize.INTEGER,
      references: {
        model: 'actions_plan',
        key: 'id',
      },
      field: 'action_plan_id',
    },
    habitId: {
      allowNull: true,
      type: Sequelize.INTEGER,
      references: {
        model: 'habits',
        key: 'id',
      },
      field: 'habit_id',
    },
    date: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'date',
    },
    title: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'title',
    },
    body: {
      allowNull: true,
      type: Sequelize.STRING,
      defaultValue: null,
      field: 'body',
    },
    sent: {
      allowNull: true,
      type: Sequelize.DATE,
      field: 'sent',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_notifications'),
};
