module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('challenges', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    routeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'routes',
        key: 'id',
      },
      field: 'route_id',
    },
    name: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'name',
    },
    info: {
      type: Sequelize.STRING(512),
      field: 'info',
    },
    link: {
      type: Sequelize.TEXT,
      field: 'link',
    },
  }),
  down: queryInterface => queryInterface.dropTable('challenges'),
};
