module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('user_actions_plan', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    userAspectReinventationId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'user_aspects_reinventation',
        key: 'id',
      },
      field: 'user_aspect_reinventation_id',
    },
    actionPlanId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'actions_plan',
        key: 'id',
      },
      field: 'action_plan_id',
    },
    active: {
      type: Sequelize.STRING(45),
      field: 'active',
    },
    completed: {
      type: Sequelize.INTEGER,
      field: 'completed',
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'created_at',
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE,
      defaultValue: Sequelize.fn('now'),
      field: 'updated_at',
    },
    deletedAt: {
      type: Sequelize.DATE,
      field: 'deleted_at',
    },
  }),
  down: queryInterface => queryInterface.dropTable('user_actions_plan'),
};
