module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('habits', 'challenge_id', {
        allowNull: false,
        type: Sequelize.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('habits', 'challenge_id');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
