module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('actions_plan', 'challenge_id', {
        allowNull: false,
        type: Sequelize.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('actions_plan', 'challenge_id');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
