module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('users', 'coaching_reason_id', {
        allowNull: true,
        type: Sequelize.INTEGER,
        references: {
          model: 'coaching_reasons',
          key: 'id',
        },
        field: 'coaching_reason_id',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('users', 'coaching_reason_id');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
