module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('route_strength', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    routeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'routes',
        key: 'id',
      },
      field: 'route_id',
    },
    strengthId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'strengths',
        key: 'id',
      },
      field: 'strength_id',
    },
    pdfPath: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'pdf_path',
    },
  }),
  down: queryInterface => queryInterface.dropTable('route_strength'),
};
