module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('challenges', 'icon', {
        allowNull: true,
        type: Sequelize.STRING,
        field: 'icon',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('challenges', 'icon');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
