module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('user_aspects_reinventation', 'user_id', {
        allowNull: false,
        type: Sequelize.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      });
      await queryInterface.addColumn('user_aspects_reinventation', 'is_active', {
        allowNull: false,
        defaultValue: 0,
        type: Sequelize.INTEGER,
        field: 'is_active',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('aspects_reinventation_types', 'user_id');
      await queryInterface.removeColumn('aspects_reinventation_types', 'is_active');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
