module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('powerful_questions', 'subtitle', {
        allowNull: true,
        type: Sequelize.STRING,
        field: 'subtitle',
      });
      await queryInterface.addColumn('powerful_questions', 'description', {
        allowNull: true,
        type: Sequelize.TEXT,
        field: 'description',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('powerful_questions', 'subtitle');
      await queryInterface.removeColumn('powerful_questions', 'description');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
