module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('gifts', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    type: {
      allowNull: false,
      type: Sequelize.ENUM('video', 'image', 'podcast'),
      field: 'type',
    },
    routeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'routes',
        key: 'id',
      },
      field: 'route_id',
    },
    challengeId: {
      allowNull: true,
      type: Sequelize.INTEGER,
      references: {
        model: 'challenges',
        key: 'id',
      },
      field: 'challenge_id',
    },
    moment: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'moment',
    },
    title: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'title',
    },
    text: {
      allowNull: true,
      type: Sequelize.TEXT,
      field: 'text',
    },
    link: {
      allowNull: true,
      type: Sequelize.STRING,
      field: 'link',
    },
    width: {
      allowNull: true,
      type: Sequelize.INTEGER,
      field: 'width',
    },
    height: {
      allowNull: true,
      type: Sequelize.INTEGER,
      field: 'height',
    },
  }),
  down: queryInterface => queryInterface.dropTable('gifts'),
};
