module.exports = (sequelize, DataTypes) => {
  const CardinalPower = sequelize.define(
    'CardinalPower',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      description: {
        allowNull: false,
        type: DataTypes.TEXT,
        field: 'description',
      },
      pdfPath: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'pdf_path',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'cardinal_powers',
    },
  );
  CardinalPower.associate = models => {
    CardinalPower.hasMany(models.Questionnarie, {
      foreignKey: 'cardinalPowerId',
      as: 'questionnarie',
    });
    CardinalPower.hasMany(models.Strength, {
      foreignKey: 'cardinalPowerId',
      as: 'strengths',
    });
  };
  return CardinalPower;
};
