module.exports = (sequelize, DataTypes) => {
  const ChallengeStrength = sequelize.define(
    'ChallengeStrength',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      strengthId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'strengths',
          key: 'id',
        },
        field: 'strength_id',
      },
      challengeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'challenge_strengths',
    },
  );
  ChallengeStrength.associate = models => {
    ChallengeStrength.belongsTo(models.Challenge, {
      foreignKey: 'challengeId',
    });
    ChallengeStrength.belongsTo(models.Strength, {
      foreignKey: 'strengthId',
    });
  };
  return ChallengeStrength;
};
