module.exports = (sequelize, DataTypes) => {
  const Country = sequelize.define(
    'Country',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      country1: {
        type: DataTypes.STRING,
        field: 'country1',
      },
      country2: {
        type: DataTypes.STRING,
        field: 'country2',
      },
      timeZone: {
        type: DataTypes.STRING,
        field: 'time_zone',
      },
      gmt: {
        type: DataTypes.STRING,
        field: 'gmt',
      },
      iso: {
        type: DataTypes.STRING,
        field: 'iso',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'countries',
    },
  );
  Country.associate = models => {
    Country.hasMany(models.User, { foreignKey: 'countryId', as: 'users' });
  };
  return Country;
};
