module.exports = (sequelize, DataTypes) => {
  const PowerfulQuestion = sequelize.define(
    'PowerfulQuestion',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      link: {
        type: DataTypes.STRING(45),
        field: 'link',
      },
      challengeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
      subtitle: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'subtitle',
      },
      description: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'description',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'powerful_questions',
    },
  );
  PowerfulQuestion.associate = models => {
    PowerfulQuestion.belongsToMany(models.UserAspectReinventation, {
      through: 'UserPowerfulQuestion',
      foreignKey: 'powerfulQuestionId',
      as: 'userAspectReinventation',
      timestamps: false,
    });
    PowerfulQuestion.belongsTo(models.Challenge, {
      foreignKey: 'challengeId',
      as: 'challenge',
    });
    PowerfulQuestion.hasMany(models.UserPowerfulQuestion, {
      foreignKey: 'powerfulQuestionId',
      as: 'userPowerfulQuestion',
    });
  };
  return PowerfulQuestion;
};
