module.exports = (sequelize, DataTypes) => {
  const PreferenceType = sequelize.define(
    'PreferenceType',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'preference_types',
    },
  );
  PreferenceType.associate = models => {
    PreferenceType.hasMany(models.Preference, { foreignKey: 'preferenceTypeId', as: 'preference' });
  };
  return PreferenceType;
};
