module.exports = (sequelize, DataTypes) => {
  const PromotionalUsedCodes = sequelize.define(
    'PromotionalUsedCodes',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      dateCreated: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'datecreated',
      },
      promCodeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'promotional_codes',
          key: 'id',
        },
        field: 'promotional_code_id',
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      platform: {
        allowNull: false,
        type: DataTypes.STRING(20),
        field: 'platform',
      }
    },
    {
      paranoid: false,
      timestamps: true,
      tableName: 'promotional_used_codes',
      createdAt: 'dateCreated',
      updatedAt: false
    },
  );
  PromotionalUsedCodes.associate = models => {

    PromotionalUsedCodes.belongsTo(models.PromotionalCode, {
      foreignKey: 'promCodeId',
    });

    PromotionalUsedCodes.hasMany(models.UserSuscription, {
      foreignKey: 'promotionalUsedCodesId',
      timestamps: false,
    });

  };
  return PromotionalUsedCodes;
};
