module.exports = (sequelize, DataTypes) => {
  const UserStrength = sequelize.define(
    'UserStrength',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      strengthId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'strengths',
          key: 'id',
        },
        field: 'strength_id',
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      value: {
        type: DataTypes.INTEGER,
        defaultValue: 0,
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'user_strengths',
    },
  );
  UserStrength.associate = models => {
    UserStrength.belongsTo(models.Strength, {
      foreignKey: 'strengthId',
    });
    UserStrength.belongsTo(models.User, {
      foreignKey: 'userId',
    });
  };
  return UserStrength;
};
