/// <reference types="node" />
import { ec as EC } from 'elliptic';
/**
 * Use types for the `bn.js` lib, e.g. `@types/bn.js`
 */
declare type BNjs = any;
interface CurveOptions {
    curveParameters: number[];
    privatePEMOptions: {
        label: string;
    };
    publicPEMOptions: {
        label: string;
    };
    curve: EC;
}
interface PrivateKey {
    version: BNjs;
    privateKey: Buffer;
    parameters: number[];
    publicKey?: {
        unused: number;
        data: Buffer;
    };
}
declare type KeyFormat = 'raw' | 'pem' | 'der';
export default class KeyEncoder {
    static ECPrivateKeyASN: any;
    static SubjectPublicKeyInfoASN: any;
    algorithmID: number[];
    options: CurveOptions;
    constructor(options: string | CurveOptions);
    privateKeyObject(rawPrivateKey: string, rawPublicKey: string): PrivateKey;
    publicKeyObject(rawPublicKey: string): {
        algorithm: {
            id: number[];
            curve: number[];
        };
        pub: {
            unused: number;
            data: Buffer;
        };
    };
    encodePrivate(privateKey: string | Buffer, originalFormat: KeyFormat, destinationFormat: KeyFormat): string;
    encodePublic(publicKey: string | Buffer, originalFormat: KeyFormat, destinationFormat: KeyFormat): string;
}
export {};
