# Becrack backend

Becrack backend project

## Requirements

* NodeJS LTS >= v12.22.8

## Getting started

* Clone the repository

* Open the repo folder

    ```
    cd becrack-backend
    ```

* Switch to develop branch

    ```
    git checkout develop
    ```

* Install all the dependencies using npm

    ```
    npm install
    ```

* Copy `env` folder to root project.

* Create database in MySQL, using this [Development DB].

## Run project locally

    ```
    npm offline:dev
    ```

You can now access the app at <http://localhost:10000>

## Run migrations on production

* Connect to instance.

    ```
    ssh -i ~/.ssh/becrack-key.pem ec2-user@ec2-3-88-220-190.compute-1.amazonaws.com
    ```

* Open project directory:

    ```
    cd /home/ec2-user/projects/becrack-backed
    ```

* Enable key to connect with Bitbucket:

    ```
    eval `ssh-agent`; ssh-add /home/ec2-user/.ssh/bitbucket_rsa
    ```

* Run migrations:

    ```
    npm run db:migrate:prod
    ```

## Deploy on production

* Copy `env` folder to root project.

* Configure AWS profile with profile name "becrack"
* Use Serverless Framework V3 https://www.serverless.com/framework/docs/getting-started

* Deploy manually:

    ```
    npm run deploy:prod
    ```

ssh -i ~/.ssh/becrack-key.pem ec2-user@ec2-3-88-220-190.compute-1.amazonaws.com
