const AWS = require('aws-sdk');
const config = require('./config');

// configure the keys for accessing AWS
AWS.config.update({
  accessKeyId: config.get('aws.accessKey'),
  secretAccessKey: config.get('aws.secretAccessKey'),
  region: config.get('aws.region'),
  httpOptions: {
    timeout: 30000,
  },
});

// AWS.config.logger = console;

exports.uploadFile = (name, body) => {
  const s3 = new AWS.S3();
  const params = {
    Bucket: config.get('aws.bucket'),
    Key: name,
    Body: body,
  };
  return s3.upload(params).promise();
};

exports.getSignedUrl = name => {
  const signedUrlExpireSeconds = 60 * 60 * 24;
  const s3 = new AWS.S3();
  const params = {
    Bucket: config.get('aws.bucket'),
    Key: name,
    Expires: signedUrlExpireSeconds,
  };
  return s3.getSignedUrl('getObject', params);
};

exports.sendPush = async ({
  token, os, title, body,
}) => {
  const SNS = new AWS.SNS();

  const endpoint = await SNS.createPlatformEndpoint({
    PlatformApplicationArn: exports.getPlatformApplication(os),
    Token: token,
  }).promise();

  // const paramsPayload = {
  //   title: 'Title push',
  //   body: 'Body push',
  //   customParams: {
  //     param1: 'value1',
  //     param2: 'value2',
  //   },
  // };

  const paramsPayload = {
    title,
    body,
  };

  const payload = exports.getPushPayload(paramsPayload);

  const params = {
    Message: payload,
    MessageStructure: 'json',
    TargetArn: endpoint.EndpointArn,
  };

  return SNS.publish(params).promise();

};

exports.getPlatformApplication = os => {
  switch (os) {
    case 'ios':
      return config.get('aws.platformAppIos');
    case 'android':
      return config.get('aws.platformAppAndroid');
    default:
      return '';
  }
};

exports.getPushPayload = ({ title, body, customParams }) => {
  const [titleAndroid] = title.split(':');
  let payload = {
    default: title,
    APNS: {
      aps: {
        alert: title,
        sound: 'default',
        badge: 1,
      },
      ...customParams,
    },
    GCM: {
      data: customParams,
      notification: {
        title: `${titleAndroid.trim()}:`,
        body,
      },
    },
  };

  payload.APNS = JSON.stringify(payload.APNS);
  payload.GCM = JSON.stringify(payload.GCM);
  payload = JSON.stringify(payload);

  return payload;
};
