const utils = require('../utils/utils');
const designStategyServices = require('../services/designStrategy');

exports.getDesignStategy = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await designStategyServices.getDesignStategy(userId);

    utils.okResponse(res, 200, data);
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.setActiveDesignStrategy = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await designStategyServices.setActiveDesignStrategy(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
