const utils = require('../utils/utils');
const habitService = require('../services/habit');

exports.getHabits = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  try {
    const data = await habitService.getHabits(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.activeUserHabit = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    habitId = '',
    days = [],
    hour = null,
  } = req.body;

  if (!habitId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await habitService.activeUserHabit({
      userId,
      habitId,
      days,
      hour,
    });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.completeUserHabit = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const { habitId = '', completed = '' } = req.body;

  if (!habitId || ![0, 1].includes(completed)) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }
  try {
    const data = await habitService.completeUserHabit({ userId, habitId, completed });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.setActiveHabits = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;
  try {
    const data = await habitService.setActiveHabits(userId);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
