const utils = require('../utils/utils');
const suscriptionService = require('../services/suscription');

exports.create = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    suscriptionTypeId = 0,
    promotionalCodeId = 0,
    transactionData = {},
  } = req.body;

  if (!userId || !suscriptionTypeId) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    const data = await suscriptionService.create({ userId, suscriptionTypeId, promotionalCodeId, transactionData });

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.promotions = async (req, res) => {
  const {
    _doc: { userId = null },
  } = req.user;

  const {
    code = 0,
  } = req.body;

  //console.log(userId);
  //console.log(code);

  if (!userId || !code) {
    return utils.errorResponse(res, 'FALTAN_CAMPOS_REQUERIDOS');
  }

  try {
    var data = await suscriptionService.validPromotion({ userId, code });
    console.log(data);
    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.cancelOrResuscribedApple = async (req, res) => {
  const { signedPayload = '' } = req.body;

  try {
    const data = await suscriptionService.cancelOrResuscribedApple(signedPayload);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};

exports.cancelOrResuscribedAndroid = async (req, res) => {
  // const { data = {} } = req.body;

  try {
    const data = await suscriptionService.cancelOrResuscribedAndroid(req.body);

    utils.okResponse(res, 200, {
      data,
    });
  } catch (err) {
    console.error(err);

    const name = err.name || 'ERROR_INTERNO';
    const extra = err.extra || '';

    utils.errorResponse(res, name, extra);
  }
};
