module.exports = {
  up: (queryInterface, Sequelize) => queryInterface.createTable('aspects_reinventation', {
    id: {
      allowNull: false,
      autoIncrement: true,
      primaryKey: true,
      type: Sequelize.INTEGER,
    },
    name: {
      allowNull: false,
      type: Sequelize.STRING,
      field: 'name',
    },
    challengeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'challenges',
        key: 'id',
      },
      field: 'challenge_id',
    },
    aspectReinventationTypeId: {
      allowNull: false,
      type: Sequelize.INTEGER,
      references: {
        model: 'aspects_reinventation_types',
        key: 'id',
      },
      field: 'aspect_reinventation_type_id',
    },
  }),
  down: queryInterface => queryInterface.dropTable('aspects_reinventation'),
};
