module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('powerful_questions', 'challenge_id', {
        allowNull: false,
        type: Sequelize.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('powerful_questions', 'challenge_id');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
