module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('user_actions_plan', 'start_date', {
        type: Sequelize.DATE,
        field: 'start_date',
      });
      await queryInterface.addColumn('user_actions_plan', 'end_date', {
        type: Sequelize.DATE,
        field: 'end_date',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('user_actions_plan', 'start_date');
      await queryInterface.removeColumn('user_actions_plan', 'end_date');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
