module.exports = {
  up: async (queryInterface, Sequelize) => {
    try {
      await queryInterface.addColumn('aspects_reinventation_types', 'icon', {
        allowNull: true,
        type: Sequelize.STRING,
        field: 'icon',
      });
      await queryInterface.addColumn('aspects_reinventation_types', 'blocking_id', {
        allowNull: true,
        type: Sequelize.INTEGER,
        references: {
          model: 'aspects_reinventation_types',
          key: 'id',
        },
        field: 'blocking_id',
      });
    } catch (e) {
      return Promise.reject(e);
    }
  },
  down: async queryInterface => {
    try {
      await queryInterface.removeColumn('aspects_reinventation_types', 'icon');
      await queryInterface.removeColumn('aspects_reinventation_types', 'blocking_id');
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  },
};
