module.exports = (sequelize, DataTypes) => {
  const AspectReinventation = sequelize.define(
    'AspectReinventation',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      challengeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
      aspectReinventationTypeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'aspects_reinventation_types',
          key: 'id',
        },
        field: 'aspect_reinventation_type_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'aspects_reinventation',
    },
  );
  AspectReinventation.associate = models => {
    AspectReinventation.belongsTo(models.AspectReinventationType, {
      foreignKey: 'aspectReinventationTypeId',
      as: 'aspectReinventationType',
    });
    AspectReinventation.belongsTo(models.Challenge, {
      foreignKey: 'challengeId',
      as: 'challenge',
    });
    AspectReinventation.belongsToMany(models.User, {
      through: 'UserAspectReinventation',
      foreignKey: 'aspectReinventationId',
      as: 'userAspectReinventations',
      timestamps: false,
    });
  };
  return AspectReinventation;
};
