module.exports = (sequelize, DataTypes) => {
  const Behavior = sequelize.define(
    'Behavior',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      info: {
        type: DataTypes.STRING(512),
        field: 'info',
      },
      strengthId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'strengths',
          key: 'id',
        },
        field: 'strength_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'behaviors',
    },
  );
  Behavior.associate = models => {
    Behavior.belongsTo(models.Strength, { foreignKey: 'strengthId', as: 'strength' });
    Behavior.belongsToMany(models.Questionnarie, {
      through: 'QuestionnarieBehavior',
      foreignKey: 'behaviorId',
      as: 'questionnarieBehavior',
      timestamps: false,
    });

    Behavior.belongsToMany(models.BehaviorPoint, {
      through: 'QuestionnarieBehavior',
      foreignKey: 'behaviorId',
      as: 'behaviorPoint',
      timestamps: false,
    });
  };
  return Behavior;
};
