module.exports = (sequelize, DataTypes) => {
  const EducationalLevel = sequelize.define(
    'EducationalLevel',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'educational_levels',
    },
  );
  EducationalLevel.associate = models => {
    EducationalLevel.hasMany(models.User, { foreignKey: 'educationalLevelId', as: 'users' });
  };
  return EducationalLevel;
};
