module.exports = (sequelize, DataTypes) => {
  const Gift = sequelize.define(
    'Gift', {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      type: {
        allowNull: false,
        type: DataTypes.ENUM('video', 'image', 'podcast'),
        field: 'type',
      },
      routeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'routes',
          key: 'id',
        },
        field: 'route_id',
      },
      challengeId: {
        allowNull: true,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
      moment: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'moment',
      },
      title: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'title',
      },
      text: {
        allowNull: true,
        type: DataTypes.TEXT,
        field: 'text',
      },
      link: {
        allowNull: true,
        type: DataTypes.STRING,
        field: 'link',
      },
      width: {
        allowNull: true,
        type: DataTypes.INTEGER,
        field: 'width',
      },
      height: {
        allowNull: true,
        type: DataTypes.INTEGER,
        field: 'height',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'gifts',
    },
  );
  Gift.associate = models => {
    Gift.belongsTo(models.Route, {
      foreignKey: 'routeId',
      as: 'route',
    });
    Gift.belongsToMany(models.User, {
      through: 'UserGift',
      foreignKey: 'giftId',
      as: 'users',
      timestamps: false,
    });
  };
  return Gift;
};
