module.exports = (sequelize, DataTypes) => {
  const Habit = sequelize.define(
    'Habit',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      link: {
        type: DataTypes.TEXT,
        field: 'link',
      },
      challengeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'habits',
    },
  );
  Habit.associate = models => {
    Habit.belongsToMany(models.UserAspectReinventation, {
      through: 'UserHabit',
      foreignKey: 'habitId',
      as: 'userAspectReinventation',
      timestamps: false,
    });
    Habit.belongsTo(models.Challenge, {
      foreignKey: 'challengeId',
      as: 'challenge',
    });

    Habit.hasMany(models.UserHabit, {
      foreignKey: 'habitId',
      as: 'userHabit',
    });
  };
  return Habit;
};
