module.exports = (sequelize, DataTypes) => {
  const Preference = sequelize.define(
    'Preference',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      name: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'name',
      },
      icon: {
        type: DataTypes.TEXT,
        field: 'icon',
      },
      preferenceTypeId: {
        type: DataTypes.INTEGER,
        references: {
          model: 'preference_types',
          key: 'id',
        },
        field: 'preference_type_id',
      },
      info: {
        type: DataTypes.STRING(512),
        field: 'info',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'preferences',
    },
  );
  Preference.associate = models => {
    Preference.belongsTo(models.PreferenceType, {
      foreignKey: 'preferenceTypeId',
      as: 'preferenceType',
    });
    Preference.belongsToMany(models.User, {
      through: 'UserPreference',
      foreignKey: 'preferenceId',
      as: 'users',
      timestamps: false,
    });
  };
  return Preference;
};
