module.exports = (sequelize, DataTypes) => {
  const UserAspectReinventation = sequelize.define(
    'UserAspectReinventation',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      aspectReinventationId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'aspects_reinventation',
          key: 'id',
        },
        field: 'aspect_reinventation_id',
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      isActive: {
        allowNull: true,
        type: DataTypes.INTEGER,
        field: 'is_active',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'user_aspects_reinventation',
    },
  );
  UserAspectReinventation.associate = models => {
    UserAspectReinventation.belongsTo(models.AspectReinventation, {
      foreignKey: 'aspectReinventationId',
    });
    UserAspectReinventation.belongsTo(models.User, {
      foreignKey: 'userId',
    });
    UserAspectReinventation.belongsToMany(models.PowerfulQuestion, {
      through: 'UserPowerfulQuestion',
      foreignKey: 'userAspectReinventationId',
      as: 'powerfulQuestion',
      timestamps: false,
    });
    UserAspectReinventation.belongsToMany(models.ActionPlan, {
      through: 'UserActionPlan',
      foreignKey: 'userAspectReinventationId',
      as: 'actionPlan',
      timestamps: false,
    });
    UserAspectReinventation.belongsToMany(models.Habit, {
      through: 'UserHabit',
      foreignKey: 'userAspectReinventationId',
      as: 'habit',
      timestamps: false,
    });
  };
  return UserAspectReinventation;
};
