module.exports = (sequelize, DataTypes) => {
  const UserChallenge = sequelize.define(
    'UserChallenge',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      challengeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'challenges',
          key: 'id',
        },
        field: 'challenge_id',
      },
      userId: {
        allowNull: true,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      current: {
        type: DataTypes.INTEGER,
        field: 'current',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'user_challenges',
    },
  );
  UserChallenge.associate = models => {
    UserChallenge.belongsTo(models.Challenge, {
      foreignKey: 'challengeId',
    });
    UserChallenge.belongsTo(models.User, {
      foreignKey: 'userId',
    });
  };
  return UserChallenge;
};
