module.exports = (sequelize, DataTypes) => {
  const UserDeviceToken = sequelize.define(
    'UserDeviceToken',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      deviceToken: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'device_token',
      },
      deviceOS: {
        allowNull: false,
        type: DataTypes.STRING,
        field: 'device_os',
      },
      deviceVersion: {
        type: DataTypes.STRING,
        field: 'device_version',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'user_device_token',
    },
  );
  UserDeviceToken.associate = models => {
    UserDeviceToken.belongsTo(models.User, {
      foreignKey: 'userId',
    });
  };
  return UserDeviceToken;
};
