module.exports = (sequelize, DataTypes) => {
  const UserGift = sequelize.define(
    'UserGift',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      giftId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'user_gifts',
          key: 'id',
        },
        field: 'gift_id',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
    },
    {
      paranoid: false,
      timestamps: true,
      tableName: 'user_gifts',
    },
  );
  UserGift.associate = models => {
    UserGift.belongsTo(models.Gift, {
      foreignKey: 'giftId',
    });
    UserGift.belongsTo(models.User, {
      foreignKey: 'userId',
    });
  };
  return UserGift;
};
