module.exports = (sequelize, DataTypes) => {
  const UserPreference = sequelize.define(
    'UserPreference',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      preferenceId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'user_preferences',
          key: 'id',
        },
        field: 'preference_id',
      },
    },
    {
      paranoid: false,
      timestamps: false,
      tableName: 'user_preferences',
    },
  );
  UserPreference.associate = models => {
    UserPreference.belongsTo(models.Preference, {
      foreignKey: 'preferenceId',
    });
    UserPreference.belongsTo(models.User, {
      foreignKey: 'userId',
    });
  };
  return UserPreference;
};
