module.exports = (sequelize, DataTypes) => {
  const UserRoute = sequelize.define(
    'UserRoute',
    {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: DataTypes.INTEGER,
      },
      userId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'users',
          key: 'id',
        },
        field: 'user_id',
      },
      routeId: {
        allowNull: false,
        type: DataTypes.INTEGER,
        references: {
          model: 'routes',
          key: 'id',
        },
        field: 'route_id',
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'created_at',
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE,
        field: 'updated_at',
      },
      deletedAt: {
        type: DataTypes.DATE,
        field: 'deleted_at',
      },
      enabledDate: {
        type: DataTypes.DATE,
        field: 'enabled_date',
      },
      disabledDate: {
        type: DataTypes.DATE,
        field: 'disabled_date',
      },
    },
    {
      paranoid: true,
      timestamps: true,
      tableName: 'user_routes',
    },
  );
  UserRoute.associate = models => {
    UserRoute.belongsTo(models.Route, {
      foreignKey: 'routeId',
    });
    UserRoute.belongsTo(models.User, {
      foreignKey: 'userId',
    });
  };
  return UserRoute;
};
